<?php
//	Copyright  2009 by David Stansfield (david@littlesystems.com.au)
//	
//	You may distribute under the terms of the Artistic License 2.0, as specified in the README.license file.
//
//
//
// Array of MYOB tables and fields to be converted to XML
// These tables and fields will be recreated accordingly by the ODBC Bridge to Linux Client
//
// The below set of tables and fields can be extended or modified as required
// Note: MYOB provide a database dictionary with the ODBC driver
//
//									  Type			Length	Primary	Key		Indexed
$DBTables = array(
	'Address' => array(
		'AddressID'			=> array('Integer',		10,		'Y',			'Y'),
		'CardRecordID'		=> array('Integer',		10,		'N',			'Y'),
		'Location'			=> array('Integer',		1,		'N',			'N'),
		'Street'			=> array('Text',		256,	'N',			'N'),
		'City'				=> array('Text',		256,	'N',			'N'),
		'State'				=> array('Text',		256,	'N',			'N'),
		'Postcode'			=> array('Text',		10,		'N',			'N'),
		'Country'			=> array('Text',		256,	'N',			'N')
	),
	'Cards' => array(
		'CardRecordID'		=> array('Integer',		10,		'Y',			'Y'),
		'CardTypeID'		=> array('Text',		1,		'N',			'N'),
		'IsInactive'		=> array('Text',		10,		'N',			'N')
	),
	'Customers' => array(
		'CustomerID'		=> array('Integer',		10,		'Y',			'Y'),
		'CardRecordID'		=> array('Integer',		10,		'N',			'Y'),
		'Name'				=> array('Text',		52,		'N',			'Y'),
		'IsInactive'		=> array('Text',		1,		'N',			'N')
	),
	'Items' => array(
		'ItemID'			=> array('Integer',		10,		'Y',			'Y'),
		'IsInactive'		=> array('Text',		1,		'N',			'N'),
		'ItemName'			=> array('Text',		30,		'N',			'Y'),
		'ItemNumber'		=> array('Text',		30,		'N',			'Y'),
		'QuantityOnHand'	=> array('Double',		12.3,	'N',			'N'),
		'QuantityAvailable'	=> array('Double',		12.3,	'N',			'N'),
		'ItemDescription'	=> array('Text',		255,	'N',			'N')
	)
);

$myTableFieldAttributes = array('type','length','primarykey','indexed');
$myTableFieldAttributesCount = count($myTableFieldAttributes);
?>