<?php
//	Copyright  2009 by David Stansfield (david@littlesystems.com.au)
//	
//	You may distribute under the terms of the Artistic License 2.0, as specified in the README.license file.
//
include('.\Config_Global.php');
?>
<html>
<body>
<head>
<title>MYOB ODBC Bridge to Linux</title>
</head>
<h1>MYOB ODBC Bridge to Linux</h1>
<h2>Server</h2>
<h3>Configuration</h3>
<table border="1" cellpadding="3">
<tr>
  <td>Database</td>
  <td><?php echo $myODBC_DatabaseID; ?></td>
</tr>
<tr>
  <td>DSN</td>
  <td><?php echo $myODBC_DSN; ?></td>
</tr>
<tr>
  <td>Username</td>
  <td><?php echo $myODBC_Username; ?></td>
</tr>
<tr>
  <td>Password</td>
  <td><?php if ($myODBC_Password) { echo "********"; } else { echo "&nbsp;"; } ?></td>
</tr>
</table>
<h3>ODBC Status</h3>
<?php
	$myODBCConnectionStatus = "";
	$myODBCConnection = odbc_connect($myODBC_DSN, $myODBC_Username, $myODBC_Password);
	if ($myODBCConnection) {
		$myODBCConnectionStatus = "Connected";
		$myODBCResult = odbc_exec($myODBCConnection, "select CompanyName, ABN from DataFileInformation");
		if ($myODBCResult) {
			$myODBCRow=odbc_fetch_array($myODBCResult);
			$myODBCConnectionStatus .= " to ".$myODBCRow["CompanyName"]." (ABN: ".$myODBCRow["ABN"].")";
			echo $myODBCConnectionStatus;
?>
<h3>XML</h3>
<a href="./XML/schema.php">Schema</a><br />
<a href="./XML/data.php">Data</a>
</body>
</html>
<?php
			} else {
			$myODBCConnectionStatus .= ". ODBC Query Failed.";
			echo $myODBCConnectionStatus;
		}
		odbc_close($myODBCConnection);
	} else {
		$myODBCConnectionStatus = "Not connected.  Please check config.";
		echo $myODBCConnectionStatus;
	}
?>