<?php
//	Copyright  2009 by David Stansfield (david@littlesystems.com.au)
//	
//	You may distribute under the terms of the Artistic License 2.0, as specified in the README.license file.
//
include('..\Config_Global.php');

// Load Database schema
include('..\Config_'.$myODBC_DatabaseID.'.php');

// Open ODBC Connection
$myODBCConnection = odbc_connect($myODBC_DSN, $myODBC_Username, $myODBC_Password) or exit("ODBC connection failed");

$XMLdoc = new DomDocument('1.0', 'ISO-8859-1');

$myTableName = array_keys($DBTables);
$myTableCounter = 0;

// MYOB XML
$XMLroot = $XMLdoc->createElement('data');
$XMLroot = $XMLdoc->appendChild($XMLroot);

foreach ($DBTables as $DBTable) { 

//  Generate SQL query for particular table
    $mySQL = "select ";
	$myRowName = array_keys($DBTable);
	$myRowCounter = 0;
	foreach ($DBTable as $DBRow) {
		if ($myRowCounter>0) {
			$mySQL.= ", ";
		}
		$mySQL    .= $myRowName[$myRowCounter++];
	}
	$mySQL .= " from ".$myTableName[$myTableCounter];


//  Execute SQL query on particular table
	$myODBCResult = odbc_exec($myODBCConnection, $mySQL) or exit("ODBC query failed");

	$XMLtable = $XMLdoc->createElement($myTableName[$myTableCounter]);
	$XMLtable = $XMLroot->appendChild($XMLtable);

	while ($myODBCRow=odbc_fetch_array($myODBCResult)) {


		$XMLrow = $XMLdoc->createElement('row');
		$XMLrow = $XMLtable->appendChild($XMLrow);


		$myRowCounter = 0;

	//	Output each value as XML
		foreach ($DBTable as $DBRow) {
				$XMLfield = $XMLdoc->createElement($myRowName[$myRowCounter]);
				$XMLfield = $XMLrow->appendChild($XMLfield);
		
				$XMLvalue = $XMLdoc->createTextNode(utf8_encode($myODBCRow[$myRowName[$myRowCounter]]));
				$XMLvalue = $XMLfield->appendChild($XMLvalue);

				$myRowCounter++;
		}
	}

	$myTableCounter++;

}

//	Get completed XML document
$xml_string = $XMLdoc->saveXML();

//  Return XML document
echo $xml_string;

// Close ODBC Connection
odbc_close($myODBCConnection);

?> 